/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.blocks;

import OreSpawn.entities.TheKing;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.StitchedTexture;
import dangerzone.Utils;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Block;
import dangerzone.entities.Entity;
import dangerzone.threads.VBODataBuilderThread;
import org.lwjgl.opengl.GL11;

public class KingSpawnerBlock
extends Block {
    private boolean compiled = false;
    private int myrenderid = 0;
    private float blockrenderwidth = 16.0f;

    public KingSpawnerBlock(String n, String txt, int maxd, int mind) {
        super(n, txt);
        this.isStone = true;
        this.maxdamage = maxd;
        this.mindamage = mind;
        this.breaksound = "DangerZone:stonebreak";
        this.placesound = "DangerZone:stoneplace";
        this.hitsound = "DangerZone:stonehit";
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.hasOwnRenderer = true;
        this.randomtick = true;
    }

    public void tickMe(World w, int d, int x, int y, int z) {
        if (!w.isServer) {
            return;
        }
        Utils.spawnParticlesFromServer((World)w, (String)"DangerZone:ParticleSparkle", (int)15, (int)d, (double)((float)x + 0.5f), (double)((float)y + 0.25f), (double)((float)z + 0.5f));
        if (w.rand.nextInt(4) != 1) {
            return;
        }
        this.spawnCreature(w, "OreSpawn:TheKing", d, x, y + 1, z);
        w.setblock(d, x, y, z, 0);
    }

    private void spawnCreature(World w, String what, int d, int x, int y, int z) {
        TheKing e = (TheKing)w.createEntityByName(what, d, (double)x, (double)y, (double)z);
        if (e != null) {
            e.init();
            e.setGuardMode();
            w.spawnEntityInWorld((Entity)e);
        }
    }

    public void onBlockBroken(Player p, int d, int x, int y, int z, int s) {
        this.spawnCreature(p.world, "OreSpawn:TheKing", d, x, y + 1, z);
    }

    public int getBlockDrop(Player p, World w, int d, int x, int y, int z) {
        return 0;
    }

    public int getItemDrop(Player p, World w, int d, int x, int y, int z) {
        return 0;
    }

    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        float brw = this.blockrenderwidth / 2.0f;
        st = VBODataBuilderThread.findVBOtextureforblockside((int)0, (int)bid);
        v = VBODataBuilderThread.findOrMakeVBOForTexture((long[])chunkvbos, (StitchedTexture)st, (boolean)this.isTranslucent);
        if (v != null) {
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        }
    }

    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            this.myrenderid = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)this.myrenderid, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glEnd();
            GL11.glEndList();
            this.compiled = true;
        }
        wr.loadtextureforblockside(0, bid, false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glCallList((int)this.myrenderid);
        GL11.glDisable((int)3042);
    }
}

